#include "stdafx.h"
#include "desc_p2p.h"
#include "p2p.h"
#ifdef ENABLE_PORT_SECURITY
#include "config.h"
#endif

DESC_P2P::~DESC_P2P()
{
}

void DESC_P2P::Destroy()
{
	if (m_sock == INVALID_SOCKET) {
		return;
	}

	P2P_MANAGER::instance().UnregisterAcceptor(this);

	fdwatch_del_fd(m_lpFdw, m_sock);

	sys_log(0, "SYSTEM: closing p2p socket. DESC #%d", m_sock);

	socket_close(m_sock);
	m_sock = INVALID_SOCKET;

	// Chain up to base class Destroy()
	DESC::Destroy();
}


bool DESC_P2P::Setup(LPFDWATCH fdw, socket_t fd, const char * host, WORD wPort)
{
	m_lpFdw = fdw;
	m_stHost = host;
	m_wPort = wPort;
	m_sock = fd;

	if (!((m_lpOutputBuffer = buffer_new(1024 * 1024))))
		return false;

	if (!((m_lpInputBuffer = buffer_new(1024 * 1024))))
		return false;

	fdwatch_add_fd(m_lpFdw, m_sock, this, FDW_READ, false);

	m_iMinInputBufferLen = 1024 * 1024;
#ifdef ENABLE_PORT_SECURITY
	if (strcmp(host, g_szPublicIP) != 0) // refuse if remote host != public ip (only the same machine must be able to connect in here)
	{
		sys_log(0, "SYSTEM: new p2p connection from [%s] to [%s] fd: %d BLOCKED", host, g_szPublicIP, m_sock);
		SetPhase(PHASE_CLOSE);
		return true;
	}
#endif
	SetPhase(PHASE_P2P);

	sys_log(0, "SYSTEM: new p2p connection from [%s] fd: %d", host, m_sock);
	return true;
}

void DESC_P2P::SetPhase(BYTE bPhase)
{
	static CInputP2P s_inputP2P;

	switch (bPhase)
	{
		case PHASE_P2P:
			sys_log(1, "PHASE_P2P");

			if (m_lpInputBuffer)
				buffer_reset(m_lpInputBuffer);

			if (m_lpOutputBuffer)
				buffer_reset(m_lpOutputBuffer);

			m_pInputProcessor = &s_inputP2P;
			break;

		case PHASE_CLOSE:
			m_pInputProcessor = nullptr;
			break;

		default:
			sys_err("DESC_P2P::SetPhase : Unknown phase");
			break;
	}

	m_bPhase = bPhase;
}

